/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.CarpetServer;
import carpet.fakes.MinecraftServerInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.helpers.FeatureGenerator;
import carpet.logging.HUDController;
import carpet.script.CarpetContext;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.FileArgument;
import carpet.script.argument.FunctionArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.utils.InputValidator;
import carpet.script.utils.ScarpetJsonDeserializer;
import carpet.script.utils.ShapeDispatcher;
import carpet.script.utils.SnoopyCommandSource;
import carpet.script.utils.SystemInfo;
import carpet.script.utils.WorldTools;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import carpet.utils.Messenger;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2379;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2660;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_4565;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5575;
import net.minecraft.class_5888;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.file.PathUtils;

public class Auxiliary {
    public static final String MARKER_STRING = "__scarpet_marker";
    private static final Map<String, class_3419> mixerMap = Arrays.stream(class_3419.values()).collect(Collectors.toMap(class_3419::method_14840, k -> k));
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(Value.class, (Object)new ScarpetJsonDeserializer()).create();

    @Deprecated
    public static String recognizeResource(Value value, boolean isFloder) {
        String origfile = value.getString();
        String file = origfile.toLowerCase(Locale.ROOT).replaceAll("[^A-Za-z0-9\\-+_/]", "");
        if ((file = Arrays.stream(file.split("/+")).filter(s -> !s.isEmpty()).collect(Collectors.joining("/"))).isEmpty() && !isFloder) {
            throw new InternalExpressionException("Cannot use " + origfile + " as resource name - must have some letters and numbers");
        }
        return file;
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("sound", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                return ListValue.wrap(class_2378.field_11156.method_10235().stream().map(ValueConversions::of));
            }
            String rawString = ((Value)lv.get(0)).getString();
            class_2960 soundName = InputValidator.identifierOf(rawString);
            Vector3Argument locator = Vector3Argument.findIn(lv, 1);
            if (class_2378.field_11156.method_10223(soundName) == null) {
                throw new ThrowStatement(rawString, Throwables.UNKNOWN_SOUND);
            }
            float volume = 1.0f;
            float pitch = 1.0f;
            class_3419 mixer = class_3419.field_15250;
            if (lv.size() > 0 + locator.offset) {
                volume = (float)NumericValue.asNumber((Value)lv.get(0 + locator.offset)).getDouble();
                if (lv.size() > 1 + locator.offset) {
                    String mixerName;
                    pitch = (float)NumericValue.asNumber((Value)lv.get(1 + locator.offset)).getDouble();
                    if (lv.size() > 2 + locator.offset && (mixer = mixerMap.get((mixerName = ((Value)lv.get(2 + locator.offset)).getString()).toLowerCase(Locale.ROOT))) == null) {
                        throw new InternalExpressionException(mixerName + " is not a valid mixer name");
                    }
                }
            }
            class_243 vec = locator.vec;
            double d0 = Math.pow(volume > 1.0f ? (double)(volume * 16.0f) : 16.0, 2.0);
            int count = 0;
            long seed = cc.s.method_9225().method_8409().method_43055();
            for (class_3222 player : cc.s.method_9225().method_18766(p -> p.method_5707(vec) < d0)) {
                ++count;
                player.field_13987.method_14364((class_2596)new class_2660(soundName, mixer, vec, volume, pitch, seed));
            }
            return new NumericValue(count);
        });
        expression.addContextFunction("particle", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                return ListValue.wrap(class_2378.field_11141.method_10235().stream().map(ValueConversions::of));
            }
            MinecraftServer ms = cc.s.method_9211();
            class_3218 world = cc.s.method_9225();
            Vector3Argument locator = Vector3Argument.findIn(lv, 1);
            String particleName = ((Value)lv.get(0)).getString();
            int count = 10;
            double speed = 0.0;
            float spread = 0.5f;
            class_3222 player = null;
            if (lv.size() > locator.offset) {
                count = (int)NumericValue.asNumber((Value)lv.get(locator.offset)).getLong();
                if (lv.size() > 1 + locator.offset) {
                    spread = (float)NumericValue.asNumber((Value)lv.get(1 + locator.offset)).getDouble();
                    if (lv.size() > 2 + locator.offset) {
                        speed = NumericValue.asNumber((Value)lv.get(2 + locator.offset)).getDouble();
                        if (lv.size() > 3 + locator.offset) {
                            player = ms.method_3760().method_14566(((Value)lv.get(3 + locator.offset)).getString());
                        }
                    }
                }
            }
            class_2394 particle = ShapeDispatcher.getParticleData(particleName);
            class_243 vec = locator.vec;
            if (player == null) {
                for (class_1657 p : world.method_18456()) {
                    world.method_14166((class_3222)p, particle, true, vec.field_1352, vec.field_1351, vec.field_1350, count, (double)spread, (double)spread, (double)spread, speed);
                }
            } else {
                world.method_14166(player, particle, true, vec.field_1352, vec.field_1351, vec.field_1350, count, (double)spread, (double)spread, (double)spread, speed);
            }
            return Value.TRUE;
        });
        expression.addContextFunction("particle_line", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            String particleName = ((Value)lv.get(0)).getString();
            class_2394 particle = ShapeDispatcher.getParticleData(particleName);
            Vector3Argument pos1 = Vector3Argument.findIn(lv, 1);
            Vector3Argument pos2 = Vector3Argument.findIn(lv, pos1.offset);
            double density = 1.0;
            class_3222 player = null;
            if (lv.size() > pos2.offset + 0) {
                density = NumericValue.asNumber((Value)lv.get(pos2.offset + 0)).getDouble();
                if (density <= 0.0) {
                    throw new InternalExpressionException("Particle density should be positive");
                }
                if (lv.size() > pos2.offset + 1) {
                    Value playerValue = (Value)lv.get(pos2.offset + 1);
                    if (playerValue instanceof EntityValue) {
                        class_1297 e = ((EntityValue)playerValue).getEntity();
                        if (!(e instanceof class_3222)) {
                            throw new InternalExpressionException("'particle_line' player argument has to be a player");
                        }
                        player = (class_3222)e;
                    } else {
                        player = cc.s.method_9211().method_3760().method_14566(playerValue.getString());
                    }
                }
            }
            return new NumericValue(ShapeDispatcher.drawParticleLine(player == null ? world.method_18456() : Collections.singletonList(player), particle, pos1.vec, pos2.vec, density));
        });
        expression.addUnaryFunction("item_display_name", v -> new FormattedTextValue(ValueConversions.getItemStackFromValue(v, false).method_7964()));
        expression.addContextFunction("particle_box", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            String particleName = ((Value)lv.get(0)).getString();
            class_2394 particle = ShapeDispatcher.getParticleData(particleName);
            Vector3Argument pos1 = Vector3Argument.findIn(lv, 1);
            Vector3Argument pos2 = Vector3Argument.findIn(lv, pos1.offset);
            double density = 1.0;
            class_3222 player = null;
            if (lv.size() > pos2.offset + 0) {
                density = NumericValue.asNumber((Value)lv.get(pos2.offset + 0)).getDouble();
                if (density <= 0.0) {
                    throw new InternalExpressionException("Particle density should be positive");
                }
                if (lv.size() > pos2.offset + 1) {
                    Value playerValue = (Value)lv.get(pos2.offset + 1);
                    if (playerValue instanceof EntityValue) {
                        class_1297 e = ((EntityValue)playerValue).getEntity();
                        if (!(e instanceof class_3222)) {
                            throw new InternalExpressionException("'particle_box' player argument has to be a player");
                        }
                        player = (class_3222)e;
                    } else {
                        player = cc.s.method_9211().method_3760().method_14566(playerValue.getString());
                    }
                }
            }
            class_243 a = pos1.vec;
            class_243 b = pos2.vec;
            class_243 from = new class_243(Math.min(a.field_1352, b.field_1352), Math.min(a.field_1351, b.field_1351), Math.min(a.field_1350, b.field_1350));
            class_243 to = new class_243(Math.max(a.field_1352, b.field_1352), Math.max(a.field_1351, b.field_1351), Math.max(a.field_1350, b.field_1350));
            int particleCount = ShapeDispatcher.Box.particleMesh(player == null ? world.method_18456() : Collections.singletonList(player), particle, density, from, to);
            return new NumericValue(particleCount);
        });
        expression.alias("particle_rect", "particle_box");
        expression.addContextFunction("draw_shape", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            MinecraftServer server = world.method_8503();
            HashSet<class_3222> playerTargets = new HashSet<class_3222>();
            ArrayList<ShapeDispatcher.ShapeWithConfig> shapes = new ArrayList<ShapeDispatcher.ShapeWithConfig>();
            if (lv.size() == 1) {
                Value specLoad = (Value)lv.get(0);
                if (!(specLoad instanceof ListValue)) {
                    throw new InternalExpressionException("In bulk mode - shapes need to be provided as a list of shape specs");
                }
                for (Value list : ((ListValue)specLoad).getItems()) {
                    if (!(list instanceof ListValue)) {
                        throw new InternalExpressionException("In bulk mode - shapes need to be provided as a list of shape specs");
                    }
                    shapes.add(ShapeDispatcher.fromFunctionArgs(server, world, ((ListValue)list).getItems(), playerTargets));
                }
            } else {
                shapes.add(ShapeDispatcher.fromFunctionArgs(server, world, lv, playerTargets));
            }
            ShapeDispatcher.sendShape(playerTargets.isEmpty() ? cc.s.method_9225().method_18456() : playerTargets, shapes);
            return Value.TRUE;
        });
        expression.addContextFunction("create_marker", -1, (c, t, lv) -> {
            Vector3Argument pointLocator;
            class_2561 name;
            CarpetContext cc = (CarpetContext)c;
            class_2680 targetBlock = null;
            boolean interactable = true;
            try {
                Value nameValue = (Value)lv.get(0);
                name = nameValue.isNull() ? null : FormattedTextValue.getTextByValue(nameValue);
                pointLocator = Vector3Argument.findIn(lv, 1, true, false);
                if (lv.size() > pointLocator.offset) {
                    BlockArgument blockLocator = BlockArgument.findIn(cc, lv, pointLocator.offset, true, true, false);
                    if (blockLocator.block != null) {
                        targetBlock = blockLocator.block.getBlockState();
                    }
                    if (lv.size() > blockLocator.offset) {
                        interactable = ((Value)lv.get(blockLocator.offset)).getBoolean();
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new InternalExpressionException("'create_marker' requires a name and three coordinates, with optional direction, and optional block on its head");
            }
            class_1531 armorstand = new class_1531(class_1299.field_6131, (class_1937)cc.s.method_9225());
            double yoffset = targetBlock == null && name == null ? 0.0 : (!interactable && targetBlock == null ? -0.41 : (targetBlock == null ? (double)(-armorstand.method_17682()) - 0.41 : (double)(-armorstand.method_17682()) + 0.3));
            armorstand.method_5808(pointLocator.vec.field_1352, pointLocator.vec.field_1351 + yoffset, pointLocator.vec.field_1350, (float)pointLocator.yaw, (float)pointLocator.pitch);
            armorstand.method_5780("__scarpet_marker_" + (cc.host.getName() == null ? "" : cc.host.getName()));
            armorstand.method_5780(MARKER_STRING);
            if (targetBlock != null) {
                armorstand.method_5673(class_1304.field_6169, new class_1799((class_1935)targetBlock.method_26204().method_8389()));
            }
            if (name != null) {
                armorstand.method_5665(name);
                armorstand.method_5880(true);
            }
            armorstand.method_6919(new class_2379((float)((int)pointLocator.pitch), 0.0f, 0.0f));
            armorstand.method_5875(true);
            armorstand.method_5648(true);
            armorstand.method_5684(true);
            armorstand.method_5841().method_12778(class_1531.field_7107, (Object)((byte)(interactable ? 8 : 24)));
            cc.s.method_9225().method_8649((class_1297)armorstand);
            return new EntityValue((class_1297)armorstand);
        });
        expression.addContextFunction("remove_all_markers", 0, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            int total = 0;
            String markerName = "__scarpet_marker_" + (cc.host.getName() == null ? "" : cc.host.getName());
            for (class_1297 e : cc.s.method_9225().method_18198((class_5575)class_1299.field_6131, as -> as.method_5752().contains(markerName))) {
                ++total;
                e.method_31472();
            }
            return new NumericValue(total);
        });
        expression.addUnaryFunction("nbt", NBTSerializableValue::fromValue);
        expression.addUnaryFunction("escape_nbt", v -> new StringValue(class_2519.method_10706((String)v.getString())));
        expression.addUnaryFunction("parse_nbt", v -> {
            if (v instanceof NBTSerializableValue) {
                return ((NBTSerializableValue)v).toValue();
            }
            NBTSerializableValue ret = NBTSerializableValue.parseString(v.getString(), false);
            if (ret == null) {
                return Value.NULL;
            }
            return ret.toValue();
        });
        expression.addFunction("tag_matches", lv -> {
            int numParam = lv.size();
            if (numParam != 2 && numParam != 3) {
                throw new InternalExpressionException("'tag_matches' requires 2 or 3 arguments");
            }
            if (((Value)lv.get(1)).isNull()) {
                return Value.TRUE;
            }
            if (((Value)lv.get(0)).isNull()) {
                return Value.FALSE;
            }
            class_2520 source = ((NBTSerializableValue)NBTSerializableValue.fromValue((Value)lv.get(0))).getTag();
            class_2520 match = ((NBTSerializableValue)NBTSerializableValue.fromValue((Value)lv.get(1))).getTag();
            return BooleanValue.of(class_2512.method_10687((class_2520)match, (class_2520)source, (numParam == 2 || ((Value)lv.get(2)).getBoolean() ? 1 : 0) != 0));
        });
        expression.addFunction("encode_nbt", lv -> {
            class_2520 tag;
            int argSize = lv.size();
            if (argSize == 0 || argSize > 2) {
                throw new InternalExpressionException("'encode_nbt' requires 1 or 2 parameters");
            }
            Value v = (Value)lv.get(0);
            boolean force = argSize > 1 && ((Value)lv.get(1)).getBoolean();
            try {
                tag = v.toTag(force);
            }
            catch (NBTSerializableValue.IncompatibleTypeException ignored) {
                throw new InternalExpressionException("cannot reliably encode to a tag the value of '" + ignored.val.getPrettyString() + "'");
            }
            return new NBTSerializableValue(tag);
        });
        expression.addContextFunction("print", -1, (c, t, lv) -> {
            if (lv.size() == 0 || lv.size() > 2) {
                throw new InternalExpressionException("'print' takes one or two arguments");
            }
            class_2168 s = ((CarpetContext)c).s;
            MinecraftServer server = s.method_9211();
            Value res = (Value)lv.get(0);
            ArrayList targets = null;
            if (lv.size() == 2) {
                List<Value> playerValues = res instanceof ListValue ? ((ListValue)res).getItems() : Collections.singletonList(res);
                ArrayList playerTargets = new ArrayList();
                playerValues.forEach(pv -> {
                    class_3222 player = EntityValue.getPlayerByValue(server, pv);
                    if (player == null) {
                        throw new InternalExpressionException("Cannot target player " + pv.getString() + " in print");
                    }
                    playerTargets.add(player);
                });
                targets = playerTargets;
                res = (Value)lv.get(1);
            }
            class_2561 message = FormattedTextValue.getTextByValue(res);
            if (targets == null) {
                s.method_9226(message, false);
            } else {
                targets.forEach(p -> p.method_5671().method_9226(message, false));
            }
            return res;
        });
        expression.addContextFunction("display_title", -1, (c, t, lv) -> {
            class_5905 timesPacket;
            class_2561 title;
            String actionString;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'display_title' needs at least a target, type and message, and optionally times");
            }
            Value pVal = (Value)lv.get(0);
            if (!(pVal instanceof ListValue)) {
                pVal = ListValue.of(pVal);
            }
            MinecraftServer server = ((CarpetContext)c).s.method_9211();
            Stream<class_3222> targets = ((ListValue)pVal).getItems().stream().map(v -> {
                class_3222 player = EntityValue.getPlayerByValue(server, v);
                if (player == null) {
                    throw new InternalExpressionException("'display_title' requires a valid online player or a list of players as first argument. " + v.getString() + " is not a player.");
                }
                return player;
            });
            Function<class_2561, class_2596> packetGetter = null;
            switch (actionString = ((Value)lv.get(1)).getString().toLowerCase(Locale.ROOT)) {
                case "title": {
                    packetGetter = class_5904::new;
                    if (lv.size() >= 3) break;
                    throw new InternalExpressionException("Third argument of 'display_title' must be present except for 'clear' type");
                }
                case "subtitle": {
                    packetGetter = class_5903::new;
                    if (lv.size() >= 3) break;
                    throw new InternalExpressionException("Third argument of 'display_title' must be present except for 'clear' type");
                }
                case "actionbar": {
                    packetGetter = class_5894::new;
                    if (lv.size() >= 3) break;
                    throw new InternalExpressionException("Third argument of 'display_title' must be present except for 'clear' type");
                }
                case "clear": {
                    packetGetter = x -> new class_5888(true);
                    break;
                }
                case "player_list_header": 
                case "player_list_footer": {
                    break;
                }
                default: {
                    throw new InternalExpressionException("'display_title' requires 'title', 'subtitle', 'actionbar', 'player_list_header', 'player_list_footer' or 'clear' as second argument");
                }
            }
            boolean soundsTrue = false;
            if (lv.size() > 2) {
                pVal = (Value)lv.get(2);
                title = FormattedTextValue.getTextByValue(pVal);
                soundsTrue = pVal.getBoolean();
            } else {
                title = null;
            }
            if (packetGetter == null) {
                Map<String, class_2561> map = actionString.equals("player_list_header") ? HUDController.scarpet_headers : HUDController.scarpet_footers;
                AtomicInteger total = new AtomicInteger(0);
                List<class_3222> targetList = targets.collect(Collectors.toList());
                if (!soundsTrue) {
                    targetList.forEach(target -> {
                        map.remove(target.method_5820());
                        total.getAndIncrement();
                    });
                } else {
                    targetList.forEach(target -> {
                        map.put(target.method_5820(), (class_2561)((class_5250)title));
                        total.getAndIncrement();
                    });
                }
                HUDController.update_hud(((CarpetContext)c).s.method_9211(), targetList);
                return NumericValue.of(total.get());
            }
            if (lv.size() > 3) {
                if (lv.size() != 6) {
                    throw new InternalExpressionException("'display_title' needs all fade-in, stay and fade-out times");
                }
                int in = NumericValue.asNumber((Value)lv.get(3), "fade in for display_title").getInt();
                int stay = NumericValue.asNumber((Value)lv.get(4), "stay for display_title").getInt();
                int out = NumericValue.asNumber((Value)lv.get(5), "fade out for display_title").getInt();
                timesPacket = new class_5905(in, stay, out);
            } else {
                timesPacket = null;
            }
            class_2596 packet = packetGetter.apply(title);
            AtomicInteger total = new AtomicInteger(0);
            targets.forEach(p -> {
                if (timesPacket != null) {
                    p.field_13987.method_14364((class_2596)timesPacket);
                }
                p.field_13987.method_14364(packet);
                total.getAndIncrement();
            });
            return NumericValue.of(total.get());
        });
        expression.addFunction("format", values -> {
            if (values.size() == 0) {
                throw new InternalExpressionException("'format' requires at least one component");
            }
            if (values.get(0) instanceof ListValue && values.size() == 1) {
                values = ((ListValue)values.get(0)).getItems();
            }
            return new FormattedTextValue(Messenger.c(values.stream().map(Value::getString).toArray()));
        });
        expression.addContextFunction("run", 1, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            try {
                class_2561[] error = new class_2561[]{null};
                ArrayList<class_2561> output = new ArrayList<class_2561>();
                NumericValue retval = new NumericValue(s.method_9211().method_3734().method_44252((class_2168)new SnoopyCommandSource(s, error, output), ((Value)lv.get(0)).getString()));
                return ListValue.of(retval, ListValue.wrap(output.stream().map(FormattedTextValue::new).collect(Collectors.toList())), FormattedTextValue.of(error[0]));
            }
            catch (Exception exc) {
                return ListValue.of(Value.NULL, ListValue.of(new Value[0]), new FormattedTextValue((class_2561)class_2561.method_43470((String)exc.getMessage())));
            }
        });
        expression.addContextFunction("save", 0, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            s.method_9211().method_3760().method_14617();
            s.method_9211().method_3723(true, true, true);
            for (class_3218 world : s.method_9211().method_3738()) {
                world.method_14178().method_12127(() -> true, false);
            }
            CarpetScriptServer.LOG.warn("Saved chunks");
            return Value.TRUE;
        });
        expression.addContextFunction("tick_time", 0, (c, t, lv) -> new NumericValue(((CarpetContext)c).s.method_9211().method_3780()));
        expression.addContextFunction("world_time", 0, (c, t, lv) -> {
            c.host.issueDeprecation("world_time()");
            return new NumericValue(((CarpetContext)c).s.method_9225().method_8510());
        });
        expression.addContextFunction("day_time", -1, (c, t, lv) -> {
            NumericValue time = new NumericValue(((CarpetContext)c).s.method_9225().method_8532());
            if (lv.size() > 0) {
                long newTime = NumericValue.asNumber((Value)lv.get(0)).getLong();
                if (newTime < 0L) {
                    newTime = 0L;
                }
                ((CarpetContext)c).s.method_9225().method_29199(newTime);
            }
            return time;
        });
        expression.addContextFunction("last_tick_times", -1, (c, t, lv) -> {
            c.host.issueDeprecation("last_tick_times()");
            return SystemInfo.get("server_last_tick_times", (CarpetContext)c);
        });
        expression.addContextFunction("game_tick", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2168 s = cc.s;
            if (CarpetServer.scriptServer == null) {
                return Value.NULL;
            }
            if (!s.method_9211().method_18854()) {
                throw new InternalExpressionException("Unable to run ticks from threads");
            }
            if (CarpetServer.scriptServer.tickDepth > 16) {
                throw new InternalExpressionException("'game_tick' function caused other 'game_tick' functions to run. You should not allow that.");
            }
            try {
                long ms_total;
                long end_expected;
                long wait;
                ++CarpetServer.scriptServer.tickDepth;
                ((MinecraftServerInterface)s.method_9211()).forceTick(() -> System.nanoTime() - CarpetServer.scriptServer.tickStart < 50000000L);
                if (lv.size() > 0 && (wait = (end_expected = CarpetServer.scriptServer.tickStart + (ms_total = NumericValue.asNumber((Value)lv.get(0)).getLong()) * 1000000L) - System.nanoTime()) > 0L) {
                    try {
                        Thread.sleep(wait / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                CarpetServer.scriptServer.tickStart = System.nanoTime();
                Thread.yield();
            }
            finally {
                if (CarpetServer.scriptServer != null) {
                    --CarpetServer.scriptServer.tickDepth;
                }
            }
            if (CarpetServer.scriptServer != null && CarpetServer.scriptServer.stopAll) {
                throw new ExitStatement(Value.NULL);
            }
            return Value.TRUE;
        });
        expression.addContextFunction("seed", -1, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            c.host.issueDeprecation("seed()");
            return new NumericValue(s.method_9225().method_8412());
        });
        expression.addContextFunction("relight", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            class_3218 world = cc.s.method_9225();
            ((ThreadedAnvilChunkStorageInterface)world.method_14178().field_17254).relightChunk(new class_1923(pos));
            WorldTools.forceChunkUpdate(pos, world);
            return Value.TRUE;
        });
        expression.addContextFunction("current_dimension", 0, (c, t, lv) -> ValueConversions.of(((CarpetContext)c).s.method_9225()));
        expression.addContextFunction("view_distance", 0, (c, t, lv) -> {
            c.host.issueDeprecation("view_distance()");
            return new NumericValue(((CarpetContext)c).s.method_9211().method_3760().method_14568());
        });
        expression.addLazyFunction("in_dimension", 2, (c, t, lv) -> {
            class_2168 outerSource = ((CarpetContext)c).s;
            Value dimensionValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            class_1937 world = ValueConversions.dimFromValue(dimensionValue, outerSource.method_9211());
            if (world == outerSource.method_9225()) {
                return (LazyValue)lv.get(1);
            }
            class_2168 innerSource = outerSource.method_9227((class_3218)world);
            Context newCtx = c.recreate();
            ((CarpetContext)newCtx).s = innerSource;
            newCtx.variables = c.variables;
            Value retval = ((LazyValue)lv.get(1)).evalValue(newCtx);
            return (cc, tt) -> retval;
        });
        expression.addContextFunction("plop", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                HashMap<Value, Value> plopData = new HashMap<Value, Value>();
                CarpetContext cc = (CarpetContext)c;
                class_5455 registryManager = cc.s.method_9225().method_30349();
                plopData.put(StringValue.of("scarpet_custom"), ListValue.wrap(FeatureGenerator.featureMap.keySet().stream().sorted().map(StringValue::of).collect(Collectors.toList())));
                plopData.put(StringValue.of("features"), ListValue.wrap(class_2378.field_11138.method_10235().stream().sorted().map(ValueConversions::of).collect(Collectors.toList())));
                plopData.put(StringValue.of("configured_features"), ListValue.wrap(registryManager.method_30530(class_2378.field_25914).method_10235().stream().sorted().map(ValueConversions::of).collect(Collectors.toList())));
                plopData.put(StringValue.of("structure_types"), ListValue.wrap(class_2378.field_16644.method_10235().stream().sorted().map(ValueConversions::of).collect(Collectors.toList())));
                plopData.put(StringValue.of("structures"), ListValue.wrap(registryManager.method_30530(class_2378.field_25915).method_10235().stream().sorted().map(ValueConversions::of).collect(Collectors.toList())));
                return MapValue.wrap(plopData);
            }
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'plop' needs extra argument indicating what to plop");
            }
            String what = ((Value)lv.get(locator.offset)).getString();
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                Boolean res = FeatureGenerator.plop(what, ((CarpetContext)c).s.method_9225(), locator.block.getPos());
                if (res == null) {
                    return;
                }
                if (what.equalsIgnoreCase("forest_rock")) {
                    WorldTools.forceChunkUpdate(locator.block.getPos(), ((CarpetContext)c).s.method_9225());
                }
                result[0] = BooleanValue.of(res);
            });
            return result[0];
        });
        expression.addContextFunction("schedule", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'schedule' should have at least 2 arguments, delay and call name");
            }
            long delay = NumericValue.asNumber((Value)lv.get(0)).getLong();
            FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 1, false, false);
            CarpetServer.scriptServer.events.scheduleCall((CarpetContext)c, functionArgument.function, functionArgument.checkedArgs(), delay);
            return Value.TRUE;
        });
        expression.addImpureFunction("logger", lv -> {
            Value res;
            if (lv.size() == 1) {
                res = (Value)lv.get(0);
                CarpetScriptServer.LOG.info(res.getString());
            } else if (lv.size() == 2) {
                String level = ((Value)lv.get(0)).getString().toLowerCase(Locale.ROOT);
                res = (Value)lv.get(1);
                switch (level) {
                    case "debug": {
                        CarpetScriptServer.LOG.debug(res.getString());
                        break;
                    }
                    case "warn": {
                        CarpetScriptServer.LOG.warn(res.getString());
                        break;
                    }
                    case "info": {
                        CarpetScriptServer.LOG.info(res.getString());
                        break;
                    }
                    case "fatal": 
                    case "error": {
                        CarpetScriptServer.LOG.error(res.getString());
                        break;
                    }
                    default: {
                        throw new InternalExpressionException("Unknown log level for 'logger': " + level);
                    }
                }
            } else {
                throw new InternalExpressionException("logger takes 1 or 2 arguments");
            }
            return res;
        });
        expression.addContextFunction("list_files", 2, (c, t, lv) -> {
            FileArgument fdesc = FileArgument.from(lv, true, FileArgument.Reason.READ);
            Stream<String> files = ((CarpetScriptHost)c.host).listFolder(fdesc);
            if (files == null) {
                return Value.NULL;
            }
            return ListValue.wrap(files.map(StringValue::of).collect(Collectors.toList()));
        });
        expression.addContextFunction("read_file", 2, (c, t, lv) -> {
            Value retVal;
            FileArgument fdesc = FileArgument.from(lv, false, FileArgument.Reason.READ);
            if (fdesc.type == FileArgument.Type.NBT) {
                class_2520 state = ((CarpetScriptHost)c.host).readFileTag(fdesc);
                if (state == null) {
                    return Value.NULL;
                }
                retVal = new NBTSerializableValue(state);
            } else if (fdesc.type == FileArgument.Type.JSON) {
                JsonElement json = ((CarpetScriptHost)c.host).readJsonFile(fdesc);
                Value parsedJson = (Value)GSON.fromJson(json, Value.class);
                retVal = parsedJson == null ? Value.NULL : parsedJson;
            } else {
                List<String> content = ((CarpetScriptHost)c.host).readTextResource(fdesc);
                if (content == null) {
                    return Value.NULL;
                }
                retVal = ListValue.wrap(content.stream().map(StringValue::new).collect(Collectors.toList()));
            }
            return retVal;
        });
        expression.addContextFunction("delete_file", 2, (c, t, lv) -> BooleanValue.of(((CarpetScriptHost)c.host).removeResourceFile(FileArgument.from(lv, false, FileArgument.Reason.DELETE))));
        expression.addContextFunction("write_file", -1, (c, t, lv) -> {
            boolean success;
            if (lv.size() < 3) {
                throw new InternalExpressionException("'write_file' requires three or more arguments");
            }
            FileArgument fdesc = FileArgument.from(lv, false, FileArgument.Reason.CREATE);
            if (fdesc.type == FileArgument.Type.NBT) {
                Value val = (Value)lv.get(2);
                NBTSerializableValue tagValue = val instanceof NBTSerializableValue ? (NBTSerializableValue)val : new NBTSerializableValue(val.getString());
                class_2520 tag = tagValue.getTag();
                success = ((CarpetScriptHost)c.host).writeTagFile(tag, fdesc);
            } else if (fdesc.type == FileArgument.Type.JSON) {
                List<String> data = Collections.singletonList(GSON.toJson(((Value)lv.get(2)).toJson()));
                ((CarpetScriptHost)c.host).removeResourceFile(fdesc);
                success = ((CarpetScriptHost)c.host).appendLogFile(fdesc, data);
            } else {
                ArrayList<String> data = new ArrayList<String>();
                if (lv.size() == 3) {
                    Value val = (Value)lv.get(2);
                    if (val instanceof ListValue) {
                        List<Value> lval = ((ListValue)val).getItems();
                        lval.forEach(v -> data.add(v.getString()));
                    } else {
                        data.add(val.getString());
                    }
                } else {
                    for (int i = 2; i < lv.size(); ++i) {
                        data.add(((Value)lv.get(i)).getString());
                    }
                }
                success = ((CarpetScriptHost)c.host).appendLogFile(fdesc, data);
            }
            return BooleanValue.of(success);
        });
        expression.addContextFunction("load_app_data", -1, (c, t, lv) -> {
            FileArgument fdesc = new FileArgument(null, FileArgument.Type.NBT, null, false, false, FileArgument.Reason.READ);
            if (lv.size() > 0) {
                c.host.issueDeprecation("load_app_data(...) with arguments");
                String resource = Auxiliary.recognizeResource((Value)lv.get(0), false);
                boolean shared = lv.size() > 1 && ((Value)lv.get(1)).getBoolean();
                fdesc = new FileArgument(resource, FileArgument.Type.NBT, null, false, shared, FileArgument.Reason.READ);
            }
            return NBTSerializableValue.of(((CarpetScriptHost)c.host).readFileTag(fdesc));
        });
        expression.addContextFunction("store_app_data", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'store_app_data' needs NBT tag and an optional file");
            }
            Value val = (Value)lv.get(0);
            FileArgument fdesc = new FileArgument(null, FileArgument.Type.NBT, null, false, false, FileArgument.Reason.CREATE);
            if (lv.size() > 1) {
                c.host.issueDeprecation("store_app_data(...) with more than one argument");
                String resource = Auxiliary.recognizeResource((Value)lv.get(1), false);
                boolean shared = lv.size() > 2 && ((Value)lv.get(2)).getBoolean();
                fdesc = new FileArgument(resource, FileArgument.Type.NBT, null, false, shared, FileArgument.Reason.CREATE);
            }
            NBTSerializableValue tagValue = val instanceof NBTSerializableValue ? (NBTSerializableValue)val : new NBTSerializableValue(val.getString());
            return BooleanValue.of(((CarpetScriptHost)c.host).writeTagFile(tagValue.getTag(), fdesc));
        });
        expression.addContextFunction("statistic", 3, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3222 player = EntityValue.getPlayerByValue(cc.s.method_9211(), (Value)lv.get(0));
            if (player == null) {
                return Value.NULL;
            }
            class_2960 category = InputValidator.identifierOf(((Value)lv.get(1)).getString());
            class_2960 statName = InputValidator.identifierOf(((Value)lv.get(2)).getString());
            class_3448 type = (class_3448)class_2378.field_11152.method_10223(category);
            if (type == null) {
                return Value.NULL;
            }
            class_3445 stat = Auxiliary.getStat(type, statName);
            if (stat == null) {
                return Value.NULL;
            }
            return new NumericValue(player.method_14248().method_15025(stat));
        });
        expression.addContextFunction("handle_event", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'handle_event' requires at least two arguments, event name, and a callback");
            }
            String event = ((Value)lv.get(0)).getString();
            FunctionArgument callback = FunctionArgument.findIn(c, expression.module, lv, 1, true, false);
            CarpetScriptHost host = (CarpetScriptHost)c.host;
            if (callback.function == null) {
                return BooleanValue.of(host.scriptServer().events.removeBuiltInEvent(event, host));
            }
            return BooleanValue.of(host.scriptServer().events.handleCustomEvent(event, host, callback.function, callback.args));
        });
        expression.addContextFunction("signal_event", -1, (c, t, lv) -> {
            int counts;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'signal' requires at least one argument");
            }
            CarpetContext cc = (CarpetContext)c;
            CarpetScriptServer server = ((CarpetScriptHost)c.host).scriptServer();
            String eventName = ((Value)lv.get(0)).getString();
            if (CarpetEventServer.Event.getEvent(eventName, server) == null) {
                return Value.NULL;
            }
            class_3222 player = null;
            List<Value> args = Collections.emptyList();
            if (lv.size() > 1) {
                player = EntityValue.getPlayerByValue(server.server, (Value)lv.get(1));
                if (lv.size() > 2) {
                    args = lv.subList(2, lv.size());
                }
            }
            if ((counts = ((CarpetScriptHost)c.host).scriptServer().events.signalEvent(eventName, cc, player, args)) < 0) {
                return Value.NULL;
            }
            return new NumericValue(counts);
        });
        expression.addContextFunction("nbt_storage", -1, (c, t, lv) -> {
            if (lv.size() > 2) {
                throw new InternalExpressionException("'nbt_storage' requires 0, 1 or 2 arguments.");
            }
            CarpetContext cc = (CarpetContext)c;
            class_4565 storage = cc.s.method_9211().method_22827();
            if (lv.size() == 0) {
                return ListValue.wrap(storage.method_22542().map(i -> new StringValue(NBTSerializableValue.nameFromRegistryId(i))).collect(Collectors.toList()));
            }
            String key = ((Value)lv.get(0)).getString();
            class_2487 old_nbt = storage.method_22546(InputValidator.identifierOf(key));
            if (lv.size() == 2) {
                Value nbt = (Value)lv.get(1);
                NBTSerializableValue new_nbt = nbt instanceof NBTSerializableValue ? (NBTSerializableValue)nbt : NBTSerializableValue.parseString(nbt.getString(), true);
                storage.method_22547(InputValidator.identifierOf(key), new_nbt.getCompoundTag());
            }
            return NBTSerializableValue.of((class_2520)old_nbt);
        });
        expression.addContextFunction("create_datapack", 2, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            String origName = ((Value)lv.get(0)).getString();
            String name = InputValidator.validateSimpleString(origName, true);
            MinecraftServer server = cc.s.method_9211();
            for (String dpName : server.method_3836().method_29206()) {
                if (!dpName.equalsIgnoreCase("file/" + name + ".zip") && !dpName.equalsIgnoreCase("file/" + name)) continue;
                return Value.NULL;
            }
            Value dpdata = (Value)lv.get(1);
            if (!(dpdata instanceof MapValue)) {
                throw new InternalExpressionException("datapack data needs to be a valid map type");
            }
            class_3283 packManager = server.method_3836();
            Path dbFloder = server.method_27050(class_5218.field_24186);
            Path packFloder = dbFloder.resolve(name + ".zip");
            if (Files.exists(packFloder, new LinkOption[0]) || Files.exists(dbFloder.resolve(name), new LinkOption[0])) {
                return Value.NULL;
            }
            Boolean[] successful = new Boolean[]{true};
            server.method_19537(() -> {
                try {
                    try (FileSystem zipfs = FileSystems.newFileSystem(URI.create("jar:" + packFloder.toUri().toString()), Map.of("create", "true"));){
                        Path zipRoot = zipfs.getPath("/", new String[0]);
                        Auxiliary.zipValueToJson(zipRoot.resolve("pack.mcmeta"), MapValue.wrap(Map.of(StringValue.of("pack"), MapValue.wrap(Map.of(StringValue.of("pack_format"), new NumericValue(class_155.method_16673().getPackVersion()), StringValue.of("description"), StringValue.of(name), StringValue.of("source"), StringValue.of("scarpet"))))));
                        Auxiliary.walkTheDPMap((MapValue)dpdata, zipRoot);
                    }
                    packManager.method_14445();
                    class_3288 resourcePackProfile = packManager.method_14449("file/" + name + ".zip");
                    if (resourcePackProfile == null || packManager.method_14444().contains(resourcePackProfile)) {
                        throw new IOException();
                    }
                    ArrayList list = Lists.newArrayList((Iterable)packManager.method_14444());
                    resourcePackProfile.method_14466().method_14468((List)list, (Object)resourcePackProfile, p -> p, false);
                    ((CompletableFuture)server.method_29439((Collection)list.stream().map(class_3288::method_14463).collect(Collectors.toList())).exceptionally(exc -> {
                        successful[0] = false;
                        return null;
                    })).join();
                    if (!successful[0].booleanValue()) {
                        throw new IOException();
                    }
                }
                catch (IOException e) {
                    successful[0] = false;
                    try {
                        PathUtils.delete((Path)packFloder);
                    }
                    catch (IOException ignored) {
                        throw new InternalExpressionException("Failed to install a datapack and failed to clean up after it");
                    }
                }
            });
            return BooleanValue.of(successful[0]);
        });
        expression.addContextFunction("enable_hidden_dimensions", 0, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            cc.host.issueDeprecation("enable_hidden_dimensions in 1.18.2 and 1.19");
            return Value.NULL;
        });
    }

    private static void zipValueToJson(Path path, Value output) throws IOException {
        JsonElement element = output.toJson();
        if (element == null) {
            throw new InternalExpressionException("Cannot interpret " + output.getPrettyString() + " as a json object");
        }
        String string = GSON.toJson(element);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(string);
        }
    }

    private static void zipValueToText(Path path, Value output) throws IOException {
        String string;
        String delimiter = System.lineSeparator();
        if (output instanceof LazyListValue) {
            List<Value> toJoin = ((LazyListValue)output).unroll();
            string = toJoin.stream().map(Value::getString).collect(Collectors.joining(delimiter));
        } else if (output instanceof ListValue) {
            List<Value> toJoin = ((ListValue)output).getItems();
            string = toJoin.stream().map(Value::getString).collect(Collectors.joining(delimiter));
        } else {
            string = output.getString();
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(string);
        }
    }

    private static void zipValueToNBT(Path path, Value output) throws IOException {
        NBTSerializableValue tagValue = output instanceof NBTSerializableValue ? (NBTSerializableValue)output : new NBTSerializableValue(output.getString());
        class_2520 tag = tagValue.getTag();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        if (tag instanceof class_2487) {
            class_2507.method_10634((class_2487)((class_2487)tag), (OutputStream)Files.newOutputStream(path, new OpenOption[0]));
        }
    }

    private static void walkTheDPMap(MapValue node, Path path) throws IOException {
        Map<Value, Value> items = node.getMap();
        for (Map.Entry<Value, Value> entry : items.entrySet()) {
            Value val = entry.getValue();
            String strkey = entry.getKey().getString();
            Path child = path.resolve(strkey);
            if (strkey.endsWith(".json")) {
                Auxiliary.zipValueToJson(child, val);
                continue;
            }
            if (strkey.endsWith(".mcfunction") | strkey.endsWith(".txt") | strkey.endsWith(".mcmeta")) {
                Auxiliary.zipValueToText(child, val);
                continue;
            }
            if (strkey.endsWith(".nbt")) {
                Auxiliary.zipValueToNBT(child, val);
                continue;
            }
            if (!(val instanceof MapValue)) {
                throw new InternalExpressionException("Value of " + strkey + " should be a map");
            }
            Files.createDirectory(child, new FileAttribute[0]);
            Auxiliary.walkTheDPMap((MapValue)val, child);
        }
    }

    private static <T> class_3445<T> getStat(class_3448<T> type, class_2960 id) {
        Object key = type.method_14959().method_10223(id);
        if (key == null || !type.method_14958(key)) {
            return null;
        }
        return type.method_14956(key);
    }
}

